package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.goodsowner.validator.groups.AddressBrief;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.DeliveryAddressForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class DeliveryAddressForm {

    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;

    @NotNull(message = "参数ownerId不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, AddressBrief.class})
    private Long ownerId;

    @Length(max = 50, message = "参数addressName长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数addressName不能为空", groups = {ValidatorInsert.class})
    private String addressName;

    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotBlank(message = "参数provinceCode不能为空", groups = {ValidatorInsert.class})
    private String provinceCode;

    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotBlank(message = "参数cityCode不能为空", groups = {ValidatorInsert.class})
    private String cityCode;

    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数districtCode不能为空", groups = {ValidatorInsert.class})
    private String districtCode;

    @Length(max = 50, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数detailAddress不能为空", groups = {ValidatorInsert.class})
    private String detailAddress;

    @Length(max = 20, message = "参数deliverer长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数deliverer不能为空", groups = {ValidatorInsert.class})
    private String deliverer;

    @Length(min = 11, max = 11, message = "参数delivererPhone长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数delivererPhone不能为空", groups = {ValidatorInsert.class})
    private String delivererPhone;

    @Length(max = 20, message = "参数delivererTelephone长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String delivererTelephone;

    @Length(max = 10, message = "参数lon长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String lon;

    @Length(max = 10, message = "参数lat长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String lat;

    @Pattern(regexp = "[01]", message = "参数addressCopy不合法", groups = {ValidatorInsert.class})
    private String addressCopy;

    @Length(max = 50, message = "参数keywords长度不合法", groups = {ValidatorList.class})
    private String keywords;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
