package com.esv.freight.customer.module.vehicle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.vehicle.dao.VehicleAuditHistoryDao;
import com.esv.freight.customer.module.vehicle.entity.VehicleAuditHistoryEntity;
import com.esv.freight.customer.module.vehicle.service.VehicleAuditHistoryService;
import com.esv.freight.customer.module.vehicle.vo.VehicleAuditVO;
import org.springframework.stereotype.Service;

import java.util.List;


@Service("vehicleAuditHistoryService")
public class VehicleAuditHistoryServiceImpl extends ServiceImpl<VehicleAuditHistoryDao, VehicleAuditHistoryEntity> implements VehicleAuditHistoryService {

    @Override
    public List<VehicleAuditHistoryEntity> getVehicleAuditList(Long vehicleId) {
        return this.baseMapper.selectList(new QueryWrapper<VehicleAuditHistoryEntity>().lambda()
                .eq(VehicleAuditHistoryEntity::getVehicleId, vehicleId)
                .orderByAsc(VehicleAuditHistoryEntity::getOperateTime));
    }
}