package com.esv.freight.customer.module.goodsowner;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 17:27
 * @version:1.0
 */
public class GoodsOwnerConstants {

    /**
     * 货主类型：1-个人、2-企业
     **/
    public static final String OWNER_TYPE_PERSONAL = "1";
    public static final String OWNER_TYPE_COMPANY = "2";

    /**
     * 货主帐号创建来源：1-平台创建、2-自行注册
     **/
    public static final String OWNER_SOURCE_TYPE_PLATFORM = "1";
    public static final String OWNER_SOURCE_TYPE_REGISTER = "2";

    /**
     * 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败，APP自行注册需要平台审核
     **/
    public static final Integer OWNER_AUDIT_STATUS_UNAUDITED = 0;
    public static final Integer OWNER_AUDIT_STATUS_SUCCESS = 1;
    public static final Integer OWNER_AUDIT_STATUS_FAILURE = 2;

    /**
     * 货主帐号状态：1-正常、2-停用
     **/
    public static final String OWNER_ACCOUNT_STATUS_UNBLOCK = "1";
    public static final String OWNER_ACCOUNT_STATUS_BLOCK = "2";

}
