package com.esv.freight.customer.module.goodsowner.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 货主收货地址表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
@TableName("goods_owner_receive_address")
public class ReceiveAddressEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 货主ID
	 */
	private Long ownerId;
	/**
	 * 地址编码
	 */
	private String addressNumber;
	/**
	 * 地址名称
	 */
	private String addressName;
	/**
	 * 省份代码
	 */
	private String provinceCode;
	/**
	 * 市代码
	 */
	private String cityCode;
	/**
	 * 区县代码
	 */
	private String districtCode;
	/**
	 * 详细地址
	 */
	private String detailAddress;
	/**
	 * 收货人
	 */
	private String receiver;
	/**
	 * 收货人电话
	 */
	private String receiverPhone;
	/**
	 * 收货人座机
	 */
	private String receiverTelephone;
	/**
	 * 经度
	 */
	private BigDecimal lon;
	/**
	 * 纬度
	 */
	private BigDecimal lat;
	/**
	 * 是否默认发货地址：0-非默认，1-默认
	 */
	private Boolean defaultAddress;
	/**
	 * 0-未删除，1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
