package com.esv.freight.customer.module.goodsowner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto;
import com.esv.freight.customer.module.goodsowner.entity.DeliveryAddressEntity;
import com.esv.freight.customer.module.goodsowner.entity.ReceiveAddressEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountAndAddressForm;
import com.esv.freight.customer.module.goodsowner.form.AccountForm;
import com.esv.freight.customer.module.goodsowner.service.AccountAndAddressService;
import com.esv.freight.customer.module.goodsowner.service.GoodsOwnerAccountService;
import com.esv.freight.customer.module.goodsowner.service.DeliveryAddressService;
import com.esv.freight.customer.module.goodsowner.service.ReceiveAddressService;
import com.esv.freight.customer.module.goodsowner.vo.account4address.AccountAndAddressVO;
import com.esv.freight.customer.module.goodsowner.vo.account4address.AccountVO;
import com.esv.freight.customer.module.goodsowner.vo.account4address.DeliveryAddressVO;
import com.esv.freight.customer.module.goodsowner.vo.account4address.ReceiveAddressVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.service.impl.AccountAndAddressServiceIpml
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 10:17
 * @version:1.0
 */
@Service("accountAndAddressService")
public class AccountAndAddressServiceIpml implements AccountAndAddressService {

    private ErrorMessageComponent errorMessageComponent;

    private GoodsOwnerAccountService goodsOwnerAccountService;

    private DeliveryAddressService deliveryAddressService;

    private ReceiveAddressService receiveAddressService;

    @Autowired
    public AccountAndAddressServiceIpml(ErrorMessageComponent errorMessageComponent, GoodsOwnerAccountService goodsOwnerAccountService,
                                        DeliveryAddressService deliveryAddressService, ReceiveAddressService receiveAddressService) {
        this.errorMessageComponent = errorMessageComponent;
        this.goodsOwnerAccountService = goodsOwnerAccountService;
        this.deliveryAddressService = deliveryAddressService;
        this.receiveAddressService = receiveAddressService;
    }

    @Override
    public AccountAndAddressVO getOwnerAndAddressInfo(AccountAndAddressForm form) {
        // 1.校验货主ID是否有效
        AccountForm accountForm = new AccountForm();
        accountForm.setId(form.getOwnerId());
        AccountInfoDto accountInfoDto = this.goodsOwnerAccountService.getAccountInfo(accountForm);
        if (null == accountInfoDto) {
            throw new EException(1001, errorMessageComponent.getGoodsOwnerExtAccountAddress1001());
        }
        AccountVO accountVO = new AccountVO();
        accountVO.setOwnerId(form.getOwnerId());
        if (GoodsOwnerConstants.OWNER_TYPE_PERSONAL.equals(accountInfoDto.getOwnerType())) {
            accountVO.setOwnerName(accountInfoDto.getContactor());
        } else {
            accountVO.setOwnerName(accountInfoDto.getOwnerFullName());
        }

        // 2.校验发货地址ID是否有效
        DeliveryAddressEntity deliveryAddressEntity = this.deliveryAddressService.getBaseMapper().selectOne(
                new QueryWrapper<DeliveryAddressEntity>().lambda()
                .eq(DeliveryAddressEntity::getOwnerId, form.getOwnerId())
                .eq(DeliveryAddressEntity::getId, form.getDeliveryAddressId())
        );
        if (null == deliveryAddressEntity) {
            throw new EException(1002, errorMessageComponent.getGoodsOwnerExtAccountAddress1002());
        }
        DeliveryAddressVO deliveryAddressVO = new DeliveryAddressVO();
        BeanUtils.copyProperties(deliveryAddressEntity, deliveryAddressVO);
        deliveryAddressVO.setAddressId(deliveryAddressEntity.getId());

        // 3.校验收货地址ID是否有效
        ReceiveAddressEntity receiveAddressEntity = this.receiveAddressService.getBaseMapper().selectOne(
                new QueryWrapper<ReceiveAddressEntity>().lambda()
                        .eq(ReceiveAddressEntity::getOwnerId, form.getOwnerId())
                        .eq(ReceiveAddressEntity::getId, form.getReceiveAddressId())
        );
        if (null == receiveAddressEntity) {
            throw new EException(1003, errorMessageComponent.getGoodsOwnerExtAccountAddress1003());
        }
        ReceiveAddressVO receiveAddressVO = new ReceiveAddressVO();
        BeanUtils.copyProperties(receiveAddressEntity, receiveAddressVO);
        receiveAddressVO.setAddressId(receiveAddressEntity.getId());

        // 4.返回
        AccountAndAddressVO accountAndAddressVO = new AccountAndAddressVO();
        accountAndAddressVO.setOwnerInfo(accountVO);
        accountAndAddressVO.setDeliveryAddressInfo(deliveryAddressVO);
        accountAndAddressVO.setReceiveAddressInfo(receiveAddressVO);
        return accountAndAddressVO;
    }
}
