package com.esv.freight.customer.module.vehicle.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.driver.dto.DriverVehicleDto;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.driver.vo.VehicleDriverListVO;
import com.esv.freight.customer.module.vehicle.dao.VehicleDriverDao;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;
import com.esv.freight.customer.module.vehicle.service.VehicleDriverService;
import org.springframework.stereotype.Service;

import java.util.List;


@Service("vehicleDriverService")
public class VehicleDriverServiceImpl extends ServiceImpl<VehicleDriverDao, VehicleDriverEntity> implements VehicleDriverService {

    @Override
    public List<DriverVehicleListVO> getDriverBindVehicleList(Long driverId) {
        return this.baseMapper.selectDriverBindVehicleList(driverId);
    }

    @Override
    public List<DriverVehicleDto> getDriverVehicle4Carrier(Long carrierId) {
        return this.baseMapper.selectDriverVehicle4Carrier(carrierId);
    }

    @Override
    public List<VehicleDriverListVO> getVehicleBindDriverList(Long vehicleId) {
        return this.baseMapper.selectVehicleBindDriverList(vehicleId);
    }
}