package com.esv.freight.customer.module.driver.dto;

import lombok.Data;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.dto.DriverVehicleDto
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/06 10:06
 * @version:1.0
 */
@Data
public class DriverVehicleDto {

    /**
     * 承运商帐号ID
     */
    private Long carrierId;
    /**
     * 承运商类别（字典表）：1-企业承运人、2-个体承运人
     */
    private Integer carrierType;
    /**
     * 承运商名称
     */
    private String carrierFullName;
    /**
     * 承运商联系人
     */
    private String carrierContactor;
    /**
     * 司机ID
     */
    private String driverId;
    /**
     * 司机(帐号)手机号
     */
    private String driverAccount;
    /**
     * 司机帐号状态：1-正常、2-停用
     */
    private String driverAccountStatus;
    /**
     * 司机帐号创建来源：1-平台创建、2-自行注册
     */
    private String driverSourceType;
    /**
     * 司机帐号审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private String driverAuditStatus;
    /**
     * 司机姓名
     */
    private String driverName;
    /**
     * 车辆ID
     */
    private String vehicleId;
    /**
     * 车辆状态：1-正常、2-停用
     */
    private String vehicleStatus;
    /**
     * 车辆审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private String vehicleAuditStatus;
    /**
     * 车辆创建来源：1-平台创建、2-司机创建
     */
    private String vehicleSourceType;
    /**
     * 车辆车牌号
     */
    private String vehicleLicenseNumber;

}
