package com.esv.freight.customer.module.vehicle.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.driver.dto.DriverVehicleDto;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.driver.vo.VehicleDriverListVO;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;

import java.util.List;

/**
 * 车辆司机表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 13:37:33
 */
public interface VehicleDriverService extends IService<VehicleDriverEntity> {

    /**
     * description 查询司机绑定的车辆列表
     * param [driverId]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.DriverVehicleListVO>
     * author Administrator
     * createTime 2020/04/29 18:00
     **/
    List<DriverVehicleListVO> getDriverBindVehicleList(Long driverId);

    /**
     * description 查询车辆绑定的司机列表
     * param [vehicleId]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.VehicleDriverListVO>
     * author Administrator
     * createTime 2020/05/07 16:16
     **/
    List<VehicleDriverListVO> getVehicleBindDriverList(Long vehicleId);

    /**
     * description 查询指定承运商的司机与车辆绑定列表
     * param [carrierId]
     * return java.util.List<com.esv.freight.customer.module.driver.dto.DriverVehicleDto>
     * author Administrator
     * createTime 2020/05/06 11:09
     **/
    List<DriverVehicleDto> getDriverVehicle4Carrier(Long carrierId);

}

