package com.esv.freight.customer.module.driver.form;

import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.driver.validator.groups.ValidatorRegister;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.form.DriverInfoForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 16:21
 * @version:1.0
 */
@Data
public class DriverInfoForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;
    /**
     * 承运商帐号ID
     */
    @NotNull(message = "参数carrierId不能为空", groups = {ValidatorInsert.class, ValidatorRegister.class})
    private Long carrierId;
    /**
     * 登录帐号，司机手机号
     */
    @Length(min = 11, max = 11, message = "参数account长度不合法", groups = {ValidatorInsert.class, ValidatorRegister.class})
    @NotBlank(message = "参数account不能为空", groups = {ValidatorInsert.class})
    private String account;
    /**
     * 密码
     */
    @Length(min = 32, max = 32, message = "参数password长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数password不能为空", groups = {ValidatorInsert.class})
    private String password;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private Integer accountStatus;
    /**
     * 姓名
     */
    @Length(max = 20, message = "参数name长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数name不能为空", groups = {ValidatorInsert.class})
    private String name;
    /**
     * 身份证号码
     */
    @Length(max = 18, message = "参数idCard长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCard不能为空", groups = {ValidatorInsert.class})
    private String idCard;
    /**
     * 身份证有效期
     */
    @Length(max = 20, message = "参数idCardExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCardExpireDate不能为空", groups = {ValidatorInsert.class})
    private String idCardExpireDate;
    /**
     * 身份证正面图片URL
     */
    @Length(max = 200, message = "参数idCardFrontUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCardFrontUrl不能为空", groups = {ValidatorInsert.class})
    private String idCardFrontUrl;
    /**
     * 身份证背面图片URL
     */
    @Length(max = 200, message = "参数idCardBackUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCardBackUrl不能为空", groups = {ValidatorInsert.class})
    private String idCardBackUrl;
    /**
     * 结算对象(字典表)：1-个人、2-所属承运商
     */
    @Range(min = 1, max = 2, message = "参数settlementType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数settlementType不能为空", groups = {ValidatorInsert.class})
    private Integer settlementType;
    /**
     * 性别(字典表)：1-男、2-女、3-未知
     */
    @Range(min = 1, max = 3, message = "参数sex不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数sex不能为空", groups = {ValidatorInsert.class})
    private Integer sex;
    /**
     * 出生日期
     */
    @Length(max = 20, message = "参数birthDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String birthDate;
    /**
     * 名族
     */
    @Length(max = 20, message = "参数nation长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String nation;
    /**
     * 籍贯
     */
    @Length(max = 20, message = "参数nativePlace长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String nativePlace;
    /**
     * 住址-省份代码
     */
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String provinceCode;
    /**
     * 住址-市代码
     */
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String cityCode;
    /**
     * 住址-区县代码
     */
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String districtCode;
    /**
     * 住址-详细地址
     */
    @Length(max = 200, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String detailAddress;
    /**
     * 驾驶证号码
     */
    @Length(max = 20, message = "参数drivingLicense长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数drivingLicense不能为空", groups = {ValidatorInsert.class})
    private String drivingLicense;
    /**
     * 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
     */
    @Range(min = 0, max = 9, message = "参数drivingLicenseType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数drivingLicenseType不能为空", groups = {ValidatorInsert.class})
    private Integer drivingLicenseType;
    /**
     * 驾驶证有效期起
     */
    @Length(max = 20, message = "参数drivingLicenseStartDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String drivingLicenseStartDate;
    /**
     * 驾驶证有效期止
     */
    @Length(max = 20, message = "参数drivingLicenseEndDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String drivingLicenseEndDate;
    /**
     * 发证机关
     */
    @Length(max = 50, message = "参数drivingLicenseIssueDepartment长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String drivingLicenseIssueDepartment;
    /**
     * 初次获得驾驶证日期
     */
    @Length(max = 20, message = "参数drivingLicenseInitDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String drivingLicenseInitDate;
    /**
     * 驾驶证正面图片URL
     */
    @Length(max = 200, message = "参数drivingLicenseUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String drivingLicenseUrl;
    /**
     * 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
     */
    @Range(min = 1, max = 2, message = "参数certificateVehicle不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数certificateVehicle不能为空", groups = {ValidatorInsert.class})
    private Integer certificateVehicle;
    /**
     * 道路运输从业资格证-有效期止
     */
    @Length(max = 20, message = "参数certificateEndDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String certificateEndDate;
    /**
     * 道路运输从业资格证-从业资格证号
     */
    @Length(max = 20, message = "参数certificateNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String certificateNumber;
    /**
     * 道路运输从业资格证-正面图片URL
     */
    @Length(max = 200, message = "参数certificateUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String certificateUrl;
    /**
     * 备注
     */
    @Length(max = 100, message = "参数remark长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
