package com.esv.freight.customer.module.goodsowner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto;
import com.esv.freight.customer.module.goodsowner.entity.GoodsOwnerAccountEntity;
import com.esv.freight.customer.module.goodsowner.entity.AuditHistoryEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountForm;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;
import com.esv.freight.customer.module.goodsowner.form.AccountQueryForm;
import com.esv.freight.customer.module.goodsowner.vo.AccountAvailableVO;

import java.util.List;

/**
 * 货主基础信息表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
public interface GoodsOwnerAccountService extends IService<GoodsOwnerAccountEntity> {

    /**
     * description 通过帐号查询帐号记录
     * param [account]
     * return com.esv.freight.customer.module.goodsowner.entity.GoodsOwnerAccountEntity
     * author Administrator
     * createTime 2020/04/17 15:46
     **/
    GoodsOwnerAccountEntity getAccountRecordByAccount(String account);

    /**
     * description 通过ID查询帐号记录
     * param [id]
     * return com.esv.freight.customer.module.goodsowner.entity.GoodsOwnerAccountEntity
     * author Administrator
     * createTime 2020/04/17 15:46
     **/
    GoodsOwnerAccountEntity getAccountRecordById(Long id);

    /**
     * description 通过管理平台创建帐号
     * param [form]
     * return Long
     * author Administrator
     * createTime 2020/04/17 16:05
     **/
    Long createAccountByManager(AccountInfoForm form);

    /**
     * description 更新帐号信息
     * param [form]
     * return void
     * author Administrator
     * createTime 2020/04/18 13:46
     **/
    void updateAccountInfo(AccountInfoForm form);

    /**
     * description 停用帐号
     * param [id]
     * return void
     * author Administrator
     * createTime 2020/04/18 14:59
     **/
    void blockAccount(Long id);

    /**
     * description 启用帐号
     * param [id]
     * return void
     * author Administrator
     * createTime 2020/04/18 14:59
     **/
    void unblockAccount(Long id);

    /**
     * description 审核帐号
     * param [form]
     * return void
     * author Administrator
     * createTime 2020/04/18 15:41
     **/
    void auditAccount(AccountForm form);

    /**
     * description 获取帐号审核历史
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.entity.AuditHistoryEntity>
     * author Administrator
     * createTime 2020/04/18 16:31
     **/
    List<AuditHistoryEntity> getAuditHistory(Long id);

    /**
     * description 获取帐号详细信息
     * param [form]
     * return com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto
     * author Administrator
     * createTime 2020/04/20 9:47
     **/
    AccountInfoDto getAccountInfo(AccountForm form);

    /**
     * description 注册帐号
     * param [account]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/20 13:23
     **/
    Long registerAccount(String account);

    /**
     * description 分页查询帐号列表
     * param [queryForm]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/04/20 19:52
     **/
    PageResultVO selectAccountInfoList(AccountQueryForm queryForm);

    /**
     * description 获取所有可用货主帐号列表
     * param []
     * return java.util.List<com.esv.freight.customer.module.goodsowner.vo.AccountAvailableVO>
     * author Administrator
     * createTime 2020/04/21 9:19
     **/
    List<AccountAvailableVO> selectAllAvailableAccount();

    /**
     * description 重置帐号密码
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/16 16:19
     **/
    Integer resetAccountPwd(AccountForm form);

}

