package com.esv.freight.customer.module.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.pay.dao.UnionpayStatementDao;
import com.esv.freight.customer.module.pay.entity.UnionpayStatementEntity;
import com.esv.freight.customer.module.pay.service.UnionpayStatementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


@Slf4j
@Service("unionpayStatementService")
public class UnionpayStatementServiceImpl extends ServiceImpl<UnionpayStatementDao, UnionpayStatementEntity> implements UnionpayStatementService {

    @Override
    public UnionpayStatementEntity getRecordByDate(String date) {
        return this.baseMapper.selectOne(new LambdaQueryWrapper<UnionpayStatementEntity>().eq(UnionpayStatementEntity::getStatementDate, date));
    }
}