package com.esv.freight.customer.module.driver.form;

import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.form.AccountScoreForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/01 13:21
 * @version:1.0
 */
@Data
public class AccountScoreForm {

    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;

    @NotNull(message = "参数score不能为空", groups = {ValidatorUpdate.class})
    @Range(min = 0, message = "无效的score", groups = {ValidatorUpdate.class})
    private Integer score;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
