package com.esv.freight.customer.module.carrier.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.carrier.entity.CarrierAccountEntity;
import com.esv.freight.customer.module.carrier.form.CarrierInfoForm;
import com.esv.freight.customer.module.carrier.form.CarrierQueryForm;

/**
 * 承运商帐号表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-23 16:51:54
 */
public interface CarrierAccountService extends IService<CarrierAccountEntity> {

    /**
     * description 判断帐号是否存在
     * param [form]
     * return boolean
     * author Administrator
     * createTime 2020/04/23 19:38
     **/
    boolean isAccountExit(CarrierQueryForm form);

    /**
     * description 新增承运商
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/23 20:02
     **/
    Long insertCarrier(CarrierInfoForm form);

    /**
     * description 编辑承运商信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/24 14:27
     **/
    Integer updateCarrier(CarrierInfoForm form);

}

