package com.esv.freight.customer.module.carrier.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.util.ReqUtils;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.carrier.CarrierConstants;
import com.esv.freight.customer.module.carrier.form.CarrierInfoForm;
import com.esv.freight.customer.module.carrier.service.CarrierAccountService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 承运商帐号Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.controller.AccountController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 20:21
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/carrier/account")
@Validated
public class CarrierAccountController {

    private CarrierAccountService carrierAccountService;

    public CarrierAccountController(CarrierAccountService carrierAccountService) {
        this.carrierAccountService = carrierAccountService;
    }

    /**
     * description 新增承运商帐号
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/24 14:49
     **/
    @PostMapping("/add")
    public EResponse createAccountByManage(@RequestBody @Validated(ValidatorInsert.class) CarrierInfoForm form) throws EException {
        /****************************** 参数校验 ******************************/
        // 承运商为企业
        if (CarrierConstants.CARRIER_TYPE_COMPANY.equals(form.getCarrierType())) {
            String[] notBlankParams = new String[] {"uniCreditCode", "carrierFullName", "provinceCode", "cityCode", "districtCode", "detailAddress"
                , "legalPerson", "businessLicenseUrl"};
            ReqUtils.checkParamsNotBlank(JSONObject.parseObject(form.toString()), notBlankParams);
        }
        /****************************** 参数校验 ******************************/

        Long id = carrierAccountService.insertCarrier(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }

    /**
     * description 编辑承运商信息
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/24 14:50
     **/
    @PostMapping("/edit")
    public EResponse editAccountByManage(@RequestBody @Validated(ValidatorUpdate.class) CarrierInfoForm form) throws EException {
        /****************************** 参数校验 ******************************/
        // 承运商为企业
        if (CarrierConstants.CARRIER_TYPE_COMPANY.equals(form.getCarrierType())) {
            String[] notBlankParams = new String[] {"uniCreditCode", "carrierFullName", "provinceCode", "cityCode", "districtCode", "detailAddress"
                    , "legalPerson", "businessLicenseUrl"};
            ReqUtils.checkParamsNotBlank(JSONObject.parseObject(form.toString()), notBlankParams);
        }
        /****************************** 参数校验 ******************************/

        return EResponse.ok(carrierAccountService.updateCarrier(form));
    }
}
