package com.esv.freight.customer.module.goodsowner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.goodsowner.entity.RegularlyRouteEntity;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.RegularlyRouteForm;

import java.util.List;

/**
 * 货主常跑线路表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-21 15:27:27
 */
public interface RegularlyRouteService extends IService<RegularlyRouteEntity> {

    /**
     * description 根据线路名称查询货主线路列表
     * param [form]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.entity.RegularlyRouteEntity>
     * author Administrator
     * createTime 2020/04/22 13:32
     **/
    List<RegularlyRouteEntity> getOwnerRouteByName(RegularlyRouteForm form);

    /**
     * description 新增常跑线路
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/22 13:36
     **/
    Long add(RegularlyRouteForm form);

    /**
     * description 编辑常跑路线
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/22 14:20
     **/
    Integer edit(RegularlyRouteForm form);
    
    /**
     * description 删除常跑路线
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/22 14:57
     **/
    Integer delete(DeleteAddressForm form);

}

