package com.esv.freight.customer.common.pojo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 银联APP终端创建支付订单请求参数
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.pojo.AppUnionPayOrder
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/30 13:48
 * @version:1.0
 */
@Data
public class AppUnionPayOrderReq {
    /**
     * 商户代码(网络货运平台在支付平台的商户号)
     */
    private String merId;
    /**
     * 账单号
     */
    private String billId;
    /**
     * 账单描述
     */
    private String billDesc;
    /**
     * 交易金额(单位为分)
     */
    private Long txnAmt;
    /**
     * 请求支付平台订单发送时间
     */
    private String txnTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
