package com.esv.freight.customer.module.contract.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 线上电子合同模板表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-21 15:55:34
 */
@Data
@TableName("contract_online_template")
public class ContractOnlineTemplateEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 合同类型：1-货主与平台合同、2-司机与平台合同
	 */
	private Integer contractType;
	/**
	 * 合同模板文件ID
	 */
	private String templateFileId;
	/**
	 * 合同模板文件URL
	 */
	private String templateFileUrl;
	/**
	 * 合同模板名称
	 */
	private String templateName;
	/**
	 * 是否使用：1使用中，2-未使用
	 */
	private Integer used;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
