package com.esv.freight.customer.module.goodsowner.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 货主基础信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
@TableName("goods_owner_account")
public class AccountEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 登录帐号，货主手机号
	 */
	private String account;
	/**
	 * 帐号密码
	 */
	private String password;
	/**
	 * 密码加盐
	 */
	private String salt;
	/**
	 * 创建来源：1-平台创建、2-自行注册
	 */
	private String sourceType;
	/**
	 * 帐号状态：1-正常、2-停用
	 */
	private String accountStatus;
	/**
	 * 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败，APP自行注册需要平台审核
	 */
	private Integer auditStatus;
	/**
	 * 上报状态：字典表
	 */
	private Integer uploadStatus;
	/**
	 * 上报时间
	 */
	private Date uploadTime;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
