package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.util.ReqUtils;
import com.esv.freight.customer.common.util.VerifyUtils;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;
import com.esv.freight.customer.module.goodsowner.service.AccountService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.GoodsOwnerController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 14:33
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/account")
@Validated
public class GoodsOwnerController {

    private AccountService accountService;

    @Autowired
    public GoodsOwnerController(AccountService accountService) {
        this.accountService = accountService;
    }

    @PostMapping("/list")
    public EResponse getAccountList() {
        String account = "test";
        return EResponse.ok(accountService.getAccountRecordByAccount(account));
    }

    /**
     * description 平台用户创建帐号
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/17 17:39
     **/
    @PostMapping("/add")
    public EResponse createAccountByManage(@RequestBody @Validated(ValidatorInsert.class) AccountInfoForm form) throws EException {
        /****************************** 参数校验 ******************************/
        // 货主为企业
        if (GoodsOwnerConstants.OWNER_TYPE_COMPANY.equals(form.getOwnerType())) {
            String[] notBlankParams = new String[] {"ownerFullName", "uniCreditCode", "creditCopyUrl", "legalPerson"};
            ReqUtils.checkParamsNotBlank(JSONObject.parseObject(form.toString()), notBlankParams);
        }
        // 校验身份证号码
        if (!VerifyUtils.isValidIdCard18(form.getIdCard())) {
            throw new EException(ECode.PARAM_ERROR.code(), "无效的身份证号码");
        }
        /****************************** 参数校验 ******************************/

        return EResponse.ok(accountService.createAccountByManager(form));
    }
}
