package com.esv.freight.customer.module.vehicle.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 车辆表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-26 11:21:07
 */
@Data
@TableName("vehicle")
public class VehicleEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 承运商帐号ID
	 */
	private Long carrierId;
	/**
	 * 车牌号
	 */
	private String licenseNumber;
	/**
	 * 车辆状态：1-正常、2-停用
	 */
	private String vehicleStatus;
	/**
	 * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
	 */
	private Integer auditStatus;
	/**
	 * 入网状态：字典表
	 */
	private Integer netInStatus;
	/**
	 * 入网时间
	 */
	private String netInDate;
	/**
	 * 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
	 */
	private Integer licenseType;
	/**
	 * 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
	 */
	private Integer licenseColor;
	/**
	 * 车辆类型(字典表)
	 */
	private Integer vehicleType;
	/**
	 * 车辆长度(单位毫米)
	 */
	private Integer vehicleLength;
	/**
	 * 车辆宽度(单位毫米)
	 */
	private Integer vehicleWidth;
	/**
	 * 车辆高度(单位毫米)
	 */
	private Integer vehicleHeight;
	/**
	 * 车辆所属(字典表)：1-自有车、2-外协车
	 */
	private Integer vehicleBelong;
	/**
	 * 年审日期
	 */
	private String yearAuditDate;
	/**
	 * 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、99-其他
	 */
	private Integer energyType;
	/**
	 * 行驶证档案编号
	 */
	private String vehicleLicenseNumber;
	/**
	 * 核定载质量(吨)
	 */
	private BigDecimal loadCapacity;
	/**
	 * 总质量(吨)
	 */
	private BigDecimal totalMass;
	/**
	 * 整备质量(吨)
	 */
	private BigDecimal unladenMass;
	/**
	 * 车辆所有人
	 */
	private String vehicleOwner;
	/**
	 * 车辆所有人代码：企业-统一社会信用代码，个人-身份证号码
	 */
	private String vehicleOwnerCode;
	/**
	 * 使用性质
	 */
	private String useNature;
	/**
	 * 注册日期
	 */
	private String registerDate;
	/**
	 * 车辆识别代码
	 */
	private String vin;
	/**
	 * 品牌型号
	 */
	private String brandModel;
	/**
	 * 发动机号
	 */
	private String engineNumber;
	/**
	 * 发证日期
	 */
	private String vehicleLicenseIssuedDate;
	/**
	 * 检验有效期至
	 */
	private String vehicleLicenseExpireDate;
	/**
	 * 发证机关
	 */
	private String vehicleLicenseIssueDepartment;
	/**
	 * 道路运输证号
	 */
	private String roadCertificateNumber;
	/**
	 * 经营许可证号
	 */
	private String businessLicenseNumber;
	/**
	 * 经营许可证有效期至
	 */
	private String businessLicenseExpireDate;
	/**
	 * 车籍地-省份代码
	 */
	private String vehicleProvinceCode;
	/**
	 * 车籍地-市代码
	 */
	private String vehicleCityCode;
	/**
	 * 车籍地-区县代码
	 */
	private String vehicleDistrictCode;
	/**
	 * 是否开通ETC：1-已开通、2-未开通、3-未知
	 */
	private String etc;
	/**
	 * 上报状态(字典表)：0-未上报、1-上报成功、2-上报失败
	 */
	private Integer uploadState;
	/**
	 * 上报时间
	 */
	private String uploadTime;
	/**
	 * 删除标识：0-未删除，1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建来源：1-平台创建、2-司机创建
	 */
	private String sourceType;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
