package com.esv.freight.customer.module.carrier.form;

import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.form.CarrierInfoForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 19:23
 * @version:1.0
 */
@Data
public class CarrierInfoForm {

    /**
     *
     */
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    @Length(min = 11, max = 11, message = "参数account长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数account不能为空", groups = {ValidatorInsert.class})
    private String account;
    /**
     * 帐号密码
     */
    @Length(min = 32, max = 32, message = "参数password长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数password不能为空", groups = {ValidatorInsert.class})
    private String password;
    /**
     * 统一社会信用代码
     */
    @Length(max = 32, message = "参数uniCreditCode长度不合法", groups = {ValidatorInsert.class})
    private String uniCreditCode;
    /**
     * 承运商名称
     */
    @Length(max = 50, message = "参数carrierFullName长度不合法", groups = {ValidatorInsert.class})
    private String carrierFullName;
    /**
     * 承运商简称
     */
    @Length(max = 50, message = "参数carrierBriefName长度不合法", groups = {ValidatorInsert.class})
    private String carrierBriefName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    @Range(min = 1, max = 2, message = "参数carrierType不合法")
    @NotNull(message = "参数carrierType不能为空", groups = {ValidatorInsert.class})
    private Integer carrierType;
    /**
     * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
     */
    @Range(min = 1, max = 3, message = "参数carrierVehicleType不合法")
    @NotNull(message = "参数carrierVehicleType不能为空", groups = {ValidatorInsert.class})
    private Integer carrierVehicleType;
    /**
     * 企业注册地址-省份代码
     */
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class})
    private String provinceCode;
    /**
     * 企业注册地址-市代码
     */
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class})
    private String cityCode;
    /**
     * 企业注册地址-区县代码
     */
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class})
    private String districtCode;
    /**
     * 企业注册地址-详细地址
     */
    @Length(max = 100, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class})
    private String detailAddress;
    /**
     * 企业法人姓名
     */
    @Length(max = 20, message = "参数legalPerson长度不合法", groups = {ValidatorInsert.class})
    private String legalPerson;
    /**
     * 营业执照URL
     */
    @Length(max = 200, message = "参数businessLicenseUrl长度不合法", groups = {ValidatorInsert.class})
    private String businessLicenseUrl;
    /**
     * 道路运输经营许可证号
     */
    @Length(max = 20, message = "参数roadLicenseNumber长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数roadLicenseNumber不能为空", groups = {ValidatorInsert.class})
    private String roadLicenseNumber;
    /**
     * 经营范围
     */
    @Length(max = 200, message = "参数businessScope长度不合法", groups = {ValidatorInsert.class})
    private String businessScope;
    /**
     * 道路运输经营许可证有效期
     */
    @Length(max = 20, message = "参数roadLicenseExpireDate长度不合法", groups = {ValidatorInsert.class})
    private String roadLicenseExpireDate;
    /**
     * 道路运输经营许可证URL
     */
    @Length(max = 200, message = "参数roadLicenseUrl长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数roadLicenseUrl不能为空", groups = {ValidatorInsert.class})
    private String roadLicenseUrl;
    /**
     * 联系人
     */
    @Length(max = 20, message = "参数contactor长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数contactor不能为空", groups = {ValidatorInsert.class})
    private String contactor;
    /**
     * 电子邮件
     */
    @Length(max = 50, message = "参数email长度不合法", groups = {ValidatorInsert.class})
    private String email;
    /**
     * 信用评分：1-100
     */
    @Range(min = 1, max = 100, message = "参数creditScore不合法")
    private Integer creditScore;
    /**
     * 备注
     */
    @Length(max = 100, message = "参数remark长度不合法", groups = {ValidatorInsert.class})
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
