package com.esv.freight.customer.common.util;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.ECode;
import lombok.extern.slf4j.Slf4j;

/**
 * @description: Feign工具类
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.FeignUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 18:05
 * @version:1.0
 */
@Slf4j
public class FeignUtils {

    /**
     * description 获取Feign调用结果数据
     * param [resultJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/04/17 18:12
     **/
    public static JSONObject getFeignResultData(JSONObject resultJson) throws EException {
        log.info(resultJson.toJSONString());
        if (ECode.SUCCESS.code() != resultJson.getIntValue("code")) {
            throw new EException(resultJson.getIntValue("code"), resultJson.getString("message"));
        } else {
            return resultJson.getJSONObject("data");
        }
    }

}
