package com.esv.freight.customer.module.driver.service;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.module.driver.form.DriverVehicleForm;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;

import java.util.List;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.service.DriverVehicleService
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 16:51
 * @version:1.0
 */
public interface DriverVehicleService {

    /**
     * description 获取司机绑定的车辆列表
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.DriverVehicleListVO>
     * author Administrator
     * createTime 2020/04/29 16:55
     **/
    List<DriverVehicleListVO> getDriverBindVehicleList(Long id);

    /**
     * description 绑定司机与车辆
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/29 19:57
     **/
    Integer driverBindVehicle(DriverVehicleForm form);

    /**
     * description 解绑司机与车辆
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/30 9:38
     **/
    Integer driverUnbindVehicle(DriverVehicleForm form);

    /**
     * description 通过司机ID/车辆ID获取绑定记录
     * param [form]
     * return com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity
     * author Administrator
     * createTime 2020/04/30 15:56
     **/
    VehicleDriverEntity getRecordBy2Id(DriverVehicleForm form);
    
    /**
     * description 验证司机与车辆是否绑定
     * param [form]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/04/30 15:59
     **/
    JSONObject checkBind(DriverVehicleForm form);

}
