package com.esv.freight.customer.module.carrier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.carrier.CarrierConstants;
import com.esv.freight.customer.module.carrier.dao.CarrierInfoDao;
import com.esv.freight.customer.module.carrier.entity.CarrierInfoEntity;
import com.esv.freight.customer.module.carrier.service.CarrierInfoService;
import org.springframework.stereotype.Service;


@Service("carrierInfoService")
public class CarrierInfoServiceImpl extends ServiceImpl<CarrierInfoDao, CarrierInfoEntity> implements CarrierInfoService {

    @Override
    public String getCarrierNameById(Long carrierId) {
        String carrierName = null;
        CarrierInfoEntity carrierInfoEntity = this.baseMapper.selectOne(new QueryWrapper<CarrierInfoEntity>()
                .lambda().eq(CarrierInfoEntity::getAccountId, carrierId));
        if (null != carrierInfoEntity) {
            if (CarrierConstants.CARRIER_TYPE_COMPANY.equals(carrierInfoEntity.getCarrierType())) {
                carrierName = carrierInfoEntity.getCarrierFullName();
            } else {
                carrierName = carrierInfoEntity.getContactor();
            }
        }
        return carrierName;
    }
}