package com.esv.freight.customer.config;

import feign.RequestInterceptor;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * @description: Feign接口配置
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.config.FeignConfigure
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 18:00
 * @version:1.0
 */
@EnableFeignClients(basePackages = "com.esv.freight.customer.feign")
@Configuration
public class FeignConfigure {

    @Value("${spring.application.name}")
    private String applicationName;

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public RequestInterceptor requestInterceptor() {
        RequestInterceptor requestInterceptor = ((requestTemplate -> {
            requestTemplate.header("trace_id", MDC.get("traceId"));
            requestTemplate.header("application_name", applicationName);
        }));
        return requestInterceptor;
    }
}
