package com.esv.freight.customer.module.vehicle.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 车辆审核历史表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-26 11:21:07
 */
@Data
@TableName("vehicle_audit_history")
public class VehicleAuditHistoryEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 承运商ID
	 */
	private Long carrierId;
	/**
	 * 车辆id
	 */
	private Long vehicleId;
	/**
	 * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
	 */
	private Integer auditStatus;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 操作者
	 */
	private String operateUser;
	/**
	 * 操作时间
	 */
	private Date operateTime;

}
