package com.esv.freight.customer.module.vehicle.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import com.esv.freight.customer.module.vehicle.validator.groups.ValidatorAuditHistory;
import com.esv.freight.customer.module.vehicle.validator.groups.ValidatorBlock;
import com.esv.freight.customer.module.vehicle.validator.groups.ValidatorUnblock;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.form.VehicleQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/26 14:35
 * @version:1.0
 */
@Data
public class VehicleQueryForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class, ValidatorAuditHistory.class, ValidatorBlock.class, ValidatorUnblock.class})
    private Long id;
    /**
     * 承运商帐号ID
     */
    private Long carrierId;
    /**
     * 车辆状态：1-正常、2-停用
     */
    @Pattern(regexp = "[12]", message = "参数vehicleStatus不合法", groups = {ValidatorList.class})
    private String vehicleStatus;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    @Range(min = 0, max = 2, message = "参数auditStatus不合法", groups = {ValidatorList.class})
    private Integer auditStatus;
    /**
     * 车牌号
     */
    @Length(max = 8, message = "参数licenseNumber长度不合法", groups = {ValidatorList.class})
    private String licenseNumber;
    /**
     * 行驶证档案编号
     */
    @Length(max = 20, message = "参数vehicleLicenseNumber长度不合法", groups = {ValidatorList.class})
    private String vehicleLicenseNumber;
    /**
     * 道路运输证号
     */
    @Length(max = 50, message = "参数ownerName长度不合法", groups = {ValidatorList.class})
    private String roadCertificateNumber;
    /**
     * 车辆类型(字典表)
     */
    private Integer vehicleType;
    /**
     * 二级车辆类型(字典表)
     */
    private Integer vehicleType2;
    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
