package com.esv.freight.customer.module.carrier.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.form.CarrierQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 19:23
 * @version:1.0
 */
@Data
public class CarrierQueryForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class})
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private String accountStatus;
    /**
     * 客户编码
     */
    private String carrierNumber;
    /**
     * 统一社会信用代码
     */
    private String uniCreditCode;
    /**
     * 道路运输经营许可证号
     */
    private String roadLicenseNumber;
    /**
     * 承运商全称
     */
    private String carrierFullName;
    /**
     * 承运商名称
     */
    private String carrierName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    private Integer carrierType;
    /**
     * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
     */
    private Integer carrierVehicleType;
    /**
     * 联系人
     */
    private String contactor;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
