package com.esv.freight.customer.module.carrier.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.carrier.CarrierConstants;
import com.esv.freight.customer.module.carrier.form.CarrierInfoForm;
import com.esv.freight.customer.module.carrier.form.CarrierQueryForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.AccountControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/24 9:25
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class CarrierAccountControllerTest extends BaseTestController {

    /**
     * 新增个人承运商
     **/
    @Test
    public void a1_add_account_personal_success_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_PERSONAL);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000013");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("庞俊辉");
        form.setAccount("13512340001");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增公司承运商
     **/
    @Test
    public void a2_add_account_company_success_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000015");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("张志臣");
        form.setAccount("13512340003");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY7D");
        form.setCarrierFullName("辽宁省沈阳市奔马物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市奔马物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("张志臣");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增公司承运商：帐号已存在
     **/
    @Test
    @Rollback
    public void a3_add_account_phone_exits_failure_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增公司承运商：道路运输经营许可证号已存在
     **/
    @Test
    @Rollback
    public void a4_add_account_roadLicenseNumber_exits_failure_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512341002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 新增公司承运商：统一社会信用代码已存在
     **/
    @Test
    @Rollback
    public void a5_add_account_uniCreditCode_exits_failure_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("190105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512341002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 新增公司承运商：承运商名称已存在
     **/
    @Test
    @Rollback
    public void a6_add_account_carrierFullName_exits_failure_test() throws Exception {
        String url = "/carrier/account/add";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("190105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512349002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("99310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 编辑承运商信息
     **/
    @Test
    @Rollback
    public void b1_edit_account_company_success_test() throws Exception {
        String url = "/carrier/account/edit";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setId(2L);
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 编辑承运商信息：无效的帐号ID
     **/
    @Test
    @Rollback
    public void b2_edit_account_wrong_id_failure_test() throws Exception {
        String url = "/carrier/account/edit";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setId(99999L);
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 编辑承运商信息：道路运输经营许可证号已存在
     **/
    @Test
    @Rollback
    public void b3_edit_account_wrong_roadLicenseNumber_failure_test() throws Exception {
        String url = "/carrier/account/edit";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setId(2L);
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000013");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 编辑承运商信息：统一社会信用代码已存在
     **/
    @Test
    @Rollback
    public void b4_edit_account_wrong_uniCreditCode_failure_test() throws Exception {
        String url = "/carrier/account/edit";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setId(2L);
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY7D");
        form.setCarrierFullName("辽宁省沈阳市恒源物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市恒源物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 编辑承运商信息：承运商名称已存在
     **/
    @Test
    @Rollback
    public void b5_edit_account_wrong_carrierFullName_failure_test() throws Exception {
        String url = "/carrier/account/edit";

        // 构造数据
        CarrierInfoForm form = new CarrierInfoForm();
        form.setId(2L);
        form.setCarrierType(CarrierConstants.CARRIER_TYPE_COMPANY);
        form.setCarrierVehicleType(1);
        form.setRoadLicenseNumber("110105000014");
        form.setRoadLicenseUrl("http://127.0.0.1/road_license_001.jpg");
        form.setContactor("陈洪艳");
        form.setAccount("13512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");

        form.setUniCreditCode("91310107MA1G11CY6D");
        form.setCarrierFullName("辽宁省沈阳市奔马物流有限公司");
        form.setCarrierBriefName("辽宁省沈阳市奔马物流有限公司");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("沈河区青年大街10号");
        form.setLegalPerson("陈洪艳");
        form.setBusinessLicenseUrl("http://127.0.0.1/business_license_001.jpg");
        form.setBusinessScope("道路货物运输");
        form.setRoadLicenseExpireDate("2030年12月31日");
        form.setEmail("test001@163.com");
        form.setCreditScore(60);
        form.setRemark("这是一条测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 查询承运商详情
     **/
    @Test
    @Rollback
    public void c1_detail_success_test() throws Exception {
        String url = "/carrier/account/detail";

        // 构造数据
        CarrierQueryForm form = new CarrierQueryForm();
        form.setId(2L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 查询承运商详情：无效的帐号ID
     **/
    @Test
    @Rollback
    public void c2_detail_wrong_id_failure_test() throws Exception {
        String url = "/carrier/account/detail";

        // 构造数据
        CarrierQueryForm form = new CarrierQueryForm();
        form.setId(99999L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 查询所有承运商列表
     **/
    @Test
    @Rollback
    public void d1_detail_success_test() throws Exception {
        String url = "/carrier/account/all";

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(new JSONObject().toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertFalse(result.getJSONArray("data").isEmpty());
    }
}
