package com.esv.freight.customer.module.driver.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.vo.CarrierDriverBindVehicleDetailVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/06 11:15
 * @version:1.0
 */
@Data
public class CarrierDriverBindVehicleDetailVO {

    /**
     * 承运商ID
     */
    private Long carrierId;
    /**
     * 承运商名称
     */
    private String carrierName;
    /**
     * 司机ID
     */
    private Long driverId;
    /**
     * 司机(帐号)手机号
     */
    private String driverAccount;
    /**
     * 司机帐号状态：1-正常、2-停用
     */
    private Integer driverAccountStatus;
    /**
     * 司机帐号创建来源：1-平台创建、2-自行注册
     */
    private Integer driverSourceType;
    /**
     * 司机帐号审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer driverAuditStatus;
    /**
     * 司机姓名
     */
    private String driverName;

    /**
     * 车辆ID
     */
    private Long vehicleId;
    /**
     * 车辆状态：1-正常、2-停用
     */
    private Integer vehicleStatus;
    /**
     * 车辆审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer vehicleAuditStatus;
    /**
     * 车辆创建来源：1-平台创建、2-司机创建
     */
    private Integer vehicleSourceType;
    /**
     * 车辆车牌号
     */
    private String vehicleLicenseNumber;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
