package com.esv.freight.customer.module.carrier.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 承运商简要信息VO
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.vo.CarrierInfoBriefVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/24 16:58
 * @version:1.0
 */
@Data
public class CarrierInfoBriefVO {

    /**
     *
     */
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private Integer accountStatus;
    /**
     * 客户编码
     */
    private String carrierNumber;
    /**
     * 承运商名称
     */
    private String carrierName;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
