package com.esv.freight.customer.module.goodsowner.dto;

import lombok.Data;

import java.util.Date;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/20 9:24
 * @version:1.0
 */
@Data
public class AccountInfoDto {

    /**
     *
     */
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 登录帐号，货主手机号
     */
    private String account;
    /**
     * 帐号密码
     */
    private String password;
    /**
     * 密码加盐
     */
    private String salt;
    /**
     * 创建来源：1-平台创建、2-自行注册
     */
    private Integer sourceType;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private Integer accountStatus;
    /**
     * 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败，APP自行注册需要平台审核
     */
    private Integer auditStatus;
    /**
     * 上报状态：字典表
     */
    private Integer uploadStatus;
    /**
     * 上报时间
     */
    private Date uploadTime;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 修改者
     */
    private String updateUser;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 货主类型：1-个人、2-企业
     */
    private Integer ownerType;
    /**
     * 客户编码
     */
    private String ownerNumber;
    /**
     * 客户名称
     */
    private String ownerFullName;
    /**
     * 客户简称
     */
    private String ownerBriefName;
    /**
     * 统一社会信用代码
     */
    private String uniCreditCode;
    /**
     * 营业期限
     */
    private String creditExpireDate;
    /**
     * 营业执照正本ULR
     */
    private String creditOriginalUrl;
    /**
     * 营业执照副本ULR
     */
    private String creditCopyUrl;
    /**
     * 企业法人姓名
     */
    private String legalPerson;
    /**
     * 企业法人手机号
     */
    private String legalPhone;
    /**
     * 省份代码
     */
    private String provinceCode;
    /**
     * 市代码
     */
    private String cityCode;
    /**
     * 区县代码
     */
    private String districtCode;
    /**
     * 详细地址
     */
    private String detailAddress;
    /**
     * （个人或企业）联系人
     */
    private String contactor;
    /**
     * （个人或企业）身份证号码
     */
    private String idCard;
    /**
     * （个人或企业）身份证有效期
     */
    private String idCardExpireDate;
    /**
     * 身份证正面图片URL
     */
    private String idCardFrontUrl;
    /**
     * 身份证背面图片URL
     */
    private String idCardBackUrl;
}
