package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.DeliveryAddressForm;
import com.esv.freight.customer.module.goodsowner.form.ReceiveAddressForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.ReceiveAddressControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 16:57
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class ReceiveAddressControllerTest extends BaseTestController {

    /**
     * 新增收货地址
     **/
    @Test
    public void a1_add_success_test() throws Exception {
        String url = "/goodsowner/receive/address/add";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setOwnerId(1L);
        form.setAddressName("黄朝斌-收货地址-测试");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张作霖");
        form.setReceiverPhone("13912340001");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464052");
        form.setLat("41.800415");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增收货地址：地址名称重复
     **/
    @Test
    @Rollback
    public void a2_add_repeat_addressName_failure_test() throws Exception {
        String url = "/goodsowner/receive/address/add";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setOwnerId(1L);
        form.setAddressName("黄朝斌-收货地址-测试");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张作霖");
        form.setReceiverPhone("13912340001");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464052");
        form.setLat("41.800415");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增收货地址：参数错误
     **/
    @Test
    @Rollback
    public void a3_add_wrong_param_failure_test() throws Exception {
        String url = "/goodsowner/receive/address/add";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setOwnerId(1L);
//        form.setAddressName("黄朝斌-收货地址-测试");
//        form.setProvinceCode("210000");
//        form.setCityCode("210100");
//        form.setDistrictCode("210103");
//        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张作霖");
        form.setReceiverPhone("13912340001");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464052");
        form.setLat("41.800415");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * 编辑收货地址
     **/
    @Test
    public void b1_edit_success_test() throws Exception {
        String url = "/goodsowner/receive/address/edit";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setId(3L);
        form.setOwnerId(1L);
        form.setAddressName("黄朝斌-收货地址-测试01");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张学良");
        form.setReceiverPhone("13912340003");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464053");
        form.setLat("41.800416");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 编辑收货地址：无效的ID
     **/
    @Test
    @Rollback
    public void b2_edit_wrong_id_failure_test() throws Exception {
        String url = "/goodsowner/receive/address/edit";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setId(99999L);
        form.setOwnerId(1L);
        form.setAddressName("黄朝斌-收货地址-测试01");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张学良");
        form.setReceiverPhone("13912340003");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464053");
        form.setLat("41.800416");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 编辑收货地址：地址名称重复
     **/
    @Test
    @Rollback
    public void b3_edit_wrong_addressName_failure_test() throws Exception {
        String url = "/goodsowner/receive/address/edit";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setId(3L);
        form.setOwnerId(1L);
        form.setAddressName("收货地址");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("朝阳街少帅府巷46号");
        form.setReceiver("张学良");
        form.setReceiverPhone("13912340003");
        form.setReceiverTelephone("(024)24850576");
        form.setLon("123.464053");
        form.setLat("41.800416");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 删除收货地址
     **/
    @Test
    @Rollback
    public void c1_delete_success_test() throws Exception {
        String url = "/goodsowner/receive/address/delete";

        // 构造数据
        DeleteAddressForm form = new DeleteAddressForm();
        form.setId("1,2,3,4,5");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("count"));
    }

    /**
     * 查看收货地址详情
     **/
    @Test
    @Rollback
    public void d1_detail_success_test() throws Exception {
        String url = "/goodsowner/receive/address/detail";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setId(3L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertFalse(result.getJSONObject("data").isEmpty());
    }

    /**
     * 查看收货地址详情：无效的ID
     **/
    @Test
    @Rollback
    public void d2_detail_wrong_id_failure_test() throws Exception {
        String url = "/goodsowner/receive/address/detail";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setId(9999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 获取所有收货地址列表
     **/
    @Test
    @Rollback
    public void e1_all_success_test() throws Exception {
        String url = "/goodsowner/receive/address/all";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setOwnerId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertFalse(result.getJSONArray("data").isEmpty());
    }

    /**
     * 分页查询收货地址列表
     **/
    @Test
    public void f1_list_success_test() throws Exception {
        String url = "/goodsowner/receive/address/list";

        // 构造数据
        ReceiveAddressForm form = new ReceiveAddressForm();
        form.setPageNum(1);
        form.setPageSize(10);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("records"));
    }

}
