package com.esv.freight.customer.module.goodsowner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.freight.customer.module.goodsowner.dto.RouteDetailDto;
import com.esv.freight.customer.module.goodsowner.entity.RegularlyRouteEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 货主常跑线路表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-21 15:27:27
 */
@Mapper
public interface RegularlyRouteDao extends BaseMapper<RegularlyRouteEntity> {

    /**
     * description 查询常跑路线详情
     * param [id]
     * return com.esv.freight.customer.module.goodsowner.dto.RouteDetailDto
     * author Administrator
     * createTime 2020/04/22 15:22
     **/
    RouteDetailDto selectRouteDetail(Long id);

    /**
     * description 查询货主所有常跑路线
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.dto.RouteDetailDto>
     * author Administrator
     * createTime 2020/04/22 15:51
     **/
    List<RouteDetailDto> selectRouteOwner(Long id);
	
}
