package com.esv.freight.customer.module.carrier.dto;

import lombok.Data;

import java.util.Date;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.dto.CarrierInfoDto
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 19:20
 * @version:1.0
 */
@Data
public class CarrierInfoDto {

    /**
     *
     */
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private String accountStatus;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 客户编码
     */
    private String carrierNumber;
    /**
     * 统一社会信用代码
     */
    private String uniCreditCode;
    /**
     * 承运商名称
     */
    private String carrierFullName;
    /**
     * 承运商简称
     */
    private String carrierBriefName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    private Integer carrierType;
    /**
     * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
     */
    private Integer carrierVehicleType;
    /**
     * 企业注册地址-省份代码
     */
    private String provinceCode;
    /**
     * 企业注册地址-市代码
     */
    private String cityCode;
    /**
     * 企业注册地址-区县代码
     */
    private String districtCode;
    /**
     * 企业注册地址-详细地址
     */
    private String detailAddress;
    /**
     * 企业法人姓名
     */
    private String legalPerson;
    /**
     * 营业执照URL
     */
    private String businessLicenseUrl;
    /**
     * 道路运输经营许可证号
     */
    private String roadLicenseNumber;
    /**
     * 经营范围
     */
    private String businessScope;
    /**
     * 道路运输经营许可证有效期
     */
    private String roadLicenseExpireDate;
    /**
     * 道路运输经营许可证URL
     */
    private String roadLicenseUrl;
    /**
     * 联系人
     */
    private String contactor;
    /**
     * 电子邮件
     */
    private String email;
    /**
     * 信用评分：1-100
     */
    private Integer creditScore;
    /**
     * 备注
     */
    private String remark;

}
