package com.esv.freight.customer.common.util;

import com.baomidou.mybatisplus.core.toolkit.BeanUtils;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.esv.freight.customer.module.contract.pojo.ContractOnlineGoodsOwnerPojo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4J;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.WordTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/21 10:49
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class WordTest {

    @Test
    public void simple_test() throws Exception {
        String sourcePath = "D:\\test\\线上合同-货主.docx";
        String targetPath = "D:\\test\\线上合同-货主-合成.docx";
        String pdfPath = "D:\\test\\线上合同-货主-PDF.pdf";

        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("contactNumber", System.currentTimeMillis());
        dataMap.put("goodsOwnerName", "黄朝斌测试有限公司01");
        dataMap.put("goodsOwnerId", "1234567890");
        dataMap.put("platformName", "英思唯网络货运平台");
        dataMap.put("platformId", "123422345678");
        dataMap.put("goodsName", "test");
        dataMap.put("goodsTotal", "test");
        dataMap.put("goodsUnit", "test");
        dataMap.put("goodsUnitPrice", "test");
        dataMap.put("goodsTotalPrice", "test");
        dataMap.put("deliverAddress", "test");
        dataMap.put("receiveAddress", "test");
        dataMap.put("deliverTime", "test");
        dataMap.put("receiveTime", "test");
        dataMap.put("freightCharge", "test");
        dataMap.put("depositCharge", "test");
//        dataMap.put("signTime", DateUtils.getSysdateStr());
        dataMap.put("signTime", "{{signTime}}");

        dataMap.put("goodsOnwerSignImg", new PictureRenderData(150, 60, "D:\\test\\何锋.jpg"));
        dataMap.put("platformFreightSealImg", new PictureRenderData(203, 220, "D:\\test\\公章.jpg"));

        XWPFTemplate template = XWPFTemplate.compile(sourcePath);
        template.render(dataMap);
        FileOutputStream out = new FileOutputStream(targetPath);
        template.write(out);
        out.flush();
        out.close();
        template.close();

        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(targetPath);
            fileOutputStream = new FileOutputStream(new File(pdfPath));
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load(file);
            setFontMapper(mlPackage);
            Docx4J.toPDF(mlPackage, new FileOutputStream(new File(pdfPath)));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("docx文档转换为PDF失败");
        } finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    @Test
    public void pojo_test() throws Exception {
        String sourcePath = "D:\\test\\线上合同-货主.docx";
        String targetPath = "D:\\test\\线上合同-货主-合成.docx";
        String pdfPath = "D:\\test\\线上合同-货主-PDF.pdf";

        ContractOnlineGoodsOwnerPojo pojo = new ContractOnlineGoodsOwnerPojo();
        pojo.setContactNumber(String.valueOf(System.currentTimeMillis()));
        pojo.setGoodsOwnerName("黄朝斌测试有限公司01");
        pojo.setGoodsOwnerId("1234567890");
        pojo.setPlatformName("英思唯网络货运平台");
        pojo.setPlatformId("123422345678");
        pojo.setGoodsName("test");
        pojo.setGoodsTotal("test");
        pojo.setGoodsUnit("test");
        pojo.setGoodsUnitPrice("test");
        pojo.setGoodsTotalPrice("test");
        pojo.setDeliverAddress("test");
        pojo.setDeliverTime("test");
        pojo.setReceiveAddress("test");
        pojo.setReceiveTime("test");
        pojo.setFreightCharge("test");
        pojo.setDepositCharge("test");
        pojo.setEffectiveTime("{{effectiveTime}}");
        pojo.setGoodsOwnerSignImg(new PictureRenderData(150, 60, "D:\\test\\何锋.jpg"));
        pojo.setPlatformFreightSealImg("{{@platformFreightSealImg}}");
//        Map<String, Object> dataMap = BeanUtils.beanToMap(pojo);
//        dataMap.put("platformFreightSealImg", "{{@platformFreightSealImg}}");

        XWPFTemplate template = XWPFTemplate.compile(sourcePath);
        template.render(pojo);
        FileOutputStream out = new FileOutputStream(targetPath);
        template.write(out);
        out.flush();
        out.close();
        template.close();

        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(targetPath);
            fileOutputStream = new FileOutputStream(new File(pdfPath));
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load(file);
            setFontMapper(mlPackage);
            Docx4J.toPDF(mlPackage, new FileOutputStream(new File(pdfPath)));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("docx文档转换为PDF失败");
        } finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    private static void setFontMapper(WordprocessingMLPackage mlPackage) throws Exception {
        Mapper fontMapper = new IdentityPlusMapper();
        fontMapper.put("隶书", PhysicalFonts.get("LiSu"));
        fontMapper.put("宋体", PhysicalFonts.get("SimSun"));
        fontMapper.put("微软雅黑", PhysicalFonts.get("Microsoft Yahei"));
        fontMapper.put("黑体", PhysicalFonts.get("SimHei"));
        fontMapper.put("楷体", PhysicalFonts.get("KaiTi"));
        fontMapper.put("新宋体", PhysicalFonts.get("NSimSun"));
        fontMapper.put("华文行楷", PhysicalFonts.get("STXingkai"));
        fontMapper.put("华文仿宋", PhysicalFonts.get("STFangsong"));
        fontMapper.put("宋体扩展", PhysicalFonts.get("simsun-extB"));
        fontMapper.put("仿宋", PhysicalFonts.get("FangSong"));
        fontMapper.put("仿宋_GB2312", PhysicalFonts.get("FangSong_GB2312"));
        fontMapper.put("幼圆", PhysicalFonts.get("YouYuan"));
        fontMapper.put("华文宋体", PhysicalFonts.get("STSong"));
        fontMapper.put("华文中宋", PhysicalFonts.get("STZhongsong"));

        mlPackage.setFontMapper(fontMapper);
    }
}
