package com.esv.freight.customer.module.contract.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDelete;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/19 14:22
 * @version:1.0
 */
@Data
public class ContractOfflineGoodsOwnerForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDelete.class})
    private Long id;
    /**
     * 货主帐号ID
     */
    @NotNull(message = "参数goodsOwnerId不能为空", groups = {ValidatorInsert.class})
    private Long goodsOwnerId;
    /**
     * 合同编号
     */
    @Length(max = 50, message = "参数contractNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数contractNumber不能为空", groups = {ValidatorInsert.class})
    private String contractNumber;
    /**
     * 合同名称
     */
    @Length(max = 50, message = "参数contractName长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数contractName不能为空", groups = {ValidatorInsert.class})
    private String contractName;
    /**
     * 合同类型：1-主合同、2-补充合同、3-临时合同
     */
    @Range(min = 1, max = 3, message = "参数contractType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数contractType不能为空", groups = {ValidatorInsert.class})
    private Integer contractType;
    /**
     * 合同签订日期
     */
    @Length(min = 10, max = 10, message = "参数signDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数signDate不能为空", groups = {ValidatorInsert.class})
    private String signDate;
    /**
     * 合同起始日期
     */
    @Length(min = 10, max = 10, message = "参数startDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数startDate不能为空", groups = {ValidatorInsert.class})
    private String startDate;
    /**
     * 合同截止日期
     */
    @Length(min = 10, max = 10, message = "参数endDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数endDate不能为空", groups = {ValidatorInsert.class})
    private String endDate;
    /**
     * 合同文件URL
     */
    @Length(max = 200, message = "参数fileUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数fileUrl不能为空", groups = {ValidatorInsert.class})
    private String fileUrl;
    /**
     * 备注
     */
    @Length(max = 200, message = "参数remark长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
