package com.esv.freight.customer.module.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.feign.FeignFileService;
import com.esv.freight.customer.module.contract.ContractConstants;
import com.esv.freight.customer.module.contract.dao.ContractOnlineTemplateDao;
import com.esv.freight.customer.module.contract.entity.ContractOnlineTemplateEntity;
import com.esv.freight.customer.module.contract.form.ContractOnlineTemplateForm;
import com.esv.freight.customer.module.contract.service.ContractOnlineTemplateService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("contractOnlineTemplateService")
public class ContractOnlineTemplateServiceImpl extends ServiceImpl<ContractOnlineTemplateDao, ContractOnlineTemplateEntity> implements ContractOnlineTemplateService {

    private FeignFileService feignFileService;

    @Autowired
    public ContractOnlineTemplateServiceImpl(FeignFileService feignFileService) {
        this.feignFileService = feignFileService;
    }

    @Override
    public Long addTemplate(ContractOnlineTemplateForm form) {
        ContractOnlineTemplateEntity contractOnlineTemplateEntity = new ContractOnlineTemplateEntity();
        BeanUtils.copyProperties(form, contractOnlineTemplateEntity);
        // 默认未使用
        contractOnlineTemplateEntity.setUsed(ContractConstants.CONTRACT_TEMPLATE_USED_NO);
        this.baseMapper.insert(contractOnlineTemplateEntity);

        return contractOnlineTemplateEntity.getId();
    }

    @Override
    public ContractOnlineTemplateEntity getUsedTemplate(Integer contractType) {
        return this.baseMapper.selectOne(new LambdaQueryWrapper<ContractOnlineTemplateEntity>()
                .eq(ContractOnlineTemplateEntity::getContractType, contractType)
                .eq(ContractOnlineTemplateEntity::getUsed, ContractConstants.CONTRACT_TEMPLATE_USED_YES));
    }
}