package com.esv.freight.customer.module.vehicle.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.driver.dto.DriverVehicleDto;
import com.esv.freight.customer.module.driver.form.DriverVehicleQueryForm;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.driver.vo.VehicleDriverListVO;
import com.esv.freight.customer.module.vehicle.dao.VehicleDriverDao;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;
import com.esv.freight.customer.module.vehicle.service.VehicleDriverService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


@Service("vehicleDriverService")
public class VehicleDriverServiceImpl extends ServiceImpl<VehicleDriverDao, VehicleDriverEntity> implements VehicleDriverService {

    @Override
    public List<DriverVehicleListVO> getDriverBindVehicleList(Long driverId) {
        return this.baseMapper.selectDriverBindVehicleList(driverId);
    }

    @Override
    public List<DriverVehicleDto> getDriverVehicle4Carrier(Long carrierId) {
        return this.baseMapper.selectDriverVehicle4Carrier(carrierId);
    }

    @Override
    public List<VehicleDriverListVO> getVehicleBindDriverList(Long vehicleId) {
        return this.baseMapper.selectVehicleBindDriverList(vehicleId);
    }

    @Override
    public IPage getVehicleCanBindDriverList(IPage page, Map<String, Object> queryObj) {
        return this.baseMapper.selectVehicleCanBindDriverList(page, queryObj);
    }

    @Override
    public IPage selectDriverVehicle4Params(IPage page, DriverVehicleQueryForm queryObj) {
        return this.baseMapper.selectDriverVehicle4Params(page, queryObj);
    }
}