package com.esv.freight.customer.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.feign.FeignFileService
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 17:56
 * @version:1.0
 */
@FeignClient(value = "freight-file-service")
public interface FeignFileService {

    /**
     * description 连通性测试
     * param []
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/22 14:05
     **/
    @GetMapping(value = "/file/test/ping")
    JSONObject pingTest();

    /**
     * description 上传单个文件
     * param [bodyJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/21 16:28
     **/
    @PostMapping(value = "/file/upload/single")
    JSONObject uploadSingleFile(JSONObject bodyJson);

    /**
     * description 获取文件数据
     * param [bodyJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/21 17:59
     **/
    @PostMapping(value = "/file/download/getFileData")
    JSONObject getFileData(JSONObject bodyJson);

}
