package com.esv.freight.customer.common.component;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.component.PasswordComponentTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/20 11:23
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class PasswordComponentTest {

    @Autowired
    PasswordComponent passwordComponent;

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
    }

    @After
    public void after() {
        log.info("=================================== Test End ===================================");
    }

    @Test
    public void checkPwd4Salt_success_test() {
        String salt = passwordComponent.generateAccountPwdSalt();
        String initPwd = DigestUtils.md5Hex("123456");
        String digestPwd = passwordComponent.generatePwd4Salt(initPwd, salt);
        log.info("salt={}", salt);
        log.info("digestPwd={}", digestPwd);
        Assert.assertTrue(passwordComponent.checkPwd4Salt(initPwd, salt, digestPwd));
    }

    @Test
    public void digest_test() {
        log.info(DigestUtils.md5Hex("123456"));
    }

}
