package com.esv.superhive.cc.module.user.form;

import com.esv.superhive.cc.common.form.Update;
import com.esv.superhive.cc.common.form.Add;
import com.esv.superhive.cc.common.form.List;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.*;

/**
 * @description：
 * @author：hcbmailbox@163.com
 * @date：2020/1/13
 */
@Data
public class UserForm {

    @NotNull(message="帐号id不能为空", groups = {Update.class})
    @Pattern(regexp = "^[1-9]\\d*$", message = "无效的帐号id", groups = {Update.class})
    private String id;

    /**
     * 用户名
     */
    @Length(max = 50, message = "账号长度不合法", groups = {Add.class})
    @NotEmpty(message="账号不能为空", groups = {Add.class})
    private String account;

    /**
     * 姓名
     */
    @Length(max = 50, message = "姓名长度不合法", groups = {Add.class, Update.class, List.class})
    @NotEmpty(message = "姓名不能为空", groups = {Add.class, Update.class})
    private String realName;

    /**
     * 密码
     */
    @Length(min = 32, max = 32, message = "密码长度不合法", groups = {Add.class, Update.class})
    @NotEmpty(message = "密码不能为空", groups = {Add.class})
    private String password;

    /**
     * 邮箱
     */
    @Email(message = "邮箱不合法", groups = {Add.class, Update.class})
    private String email;

    /**
     * 手机号
     */
    @Length(max = 50, message = "手机号长度不合法", groups = {Add.class, Update.class})
    @NotEmpty(message = "手机号不能为空", groups = {Add.class, Update.class})
    private String mobile;

    /**
     * 状态  0：禁用   1：正常
     */
    @NotNull(message="状态不能为空", groups = {Add.class, Update.class})
    @Pattern(regexp = "^[01]{1}$", message = "状态不合法", groups = {Add.class, Update.class})
    private String status;

    /**
     * 所属部门id
     */
    @NotNull(message = "部门不能为空", groups = {Add.class, Update.class, List.class})
//    @Pattern(regexp = "^[1-9]\\d*$", message = "无效的部门", groups = {Add.class, Update.class, List.class})
    private String departmentId;

    /**
     * 角色ID
     */
    @NotNull(message = "角色不能为空", groups = {Add.class, Update.class})
    @Length(max = 200, message = "角色长度不合法", groups = {Add.class, Update.class, List.class})
    private String roleId;

    /**
     * 分页查询，页码
     */
    @NotNull(message = "current不能为空", groups = {List.class})
    @Pattern(regexp = "^[1-9]\\d*$", message = "current不合法", groups = {Update.class})
    private String current;

    /**
     * 分页查询，每页条数
     */
    @NotNull(message = "size不能为空", groups = {List.class})
    @Pattern(regexp = "^[1-9]\\d*$", message = "size不合法", groups = {Update.class})
    private String size;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
