package com.esv.superhive.cc.module.tenant.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.superhive.cc.common.constants.Constant;
import com.esv.superhive.cc.module.tenant.dao.TenantAdminDao;
import com.esv.superhive.cc.module.tenant.dto.TenantAdminDTO;
import com.esv.superhive.cc.module.tenant.service.TenantAdminService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantAdminServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/12 17:33
 * @version:1.0
 */
@Service("tenantAdminService")
public class TenantAdminServiceImpl implements TenantAdminService {

    private TenantAdminDao tenantAdminDao;

    @Autowired
    public TenantAdminServiceImpl(TenantAdminDao tenantAdminDao) {
        this.tenantAdminDao = tenantAdminDao;
    }

    @Override
    public IPage<TenantAdminDTO> page(IPage<TenantAdminDTO> page, Long tenantId, String account) {
        Map<String, Object> param = new HashMap<>();
        if (tenantId != null) {
            param.put("tenantId", tenantId);
        }
        if (StringUtils.isNotBlank(account)) {
            param.put("account", account);
        }
        param.put("types", (Constant.UserType.PLATFORM_ADMIN.getValue() + ", " + Constant.UserType.TENANT_ADMIN.getValue()));
        return tenantAdminDao.page(page, param);
    }
}
