package com.esv.superhive.cc.module.tenant.form;

import com.esv.superhive.cc.common.constants.Constant;
import com.esv.superhive.cc.module.role.entity.RoleMenuEntity;
import com.esv.superhive.cc.module.role.form.RowKeyForm;
import com.esv.superhive.cc.module.role.vo.RowKeyVO;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantMenuForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/13 15:31
 * @version:1.0
 */
@Data
public class TenantMenuForm extends RowKeyForm {

    /**
     * description 租户id
     * author chenfm
     * createTime 2020/4/9 9:22
     **/
    @NotNull
    private Long tenantId;

    @Override
    public List<RoleMenuEntity> roleMenuEntityList() {
        if (this.getRowKeyList() == null) {
            return new ArrayList<>();
        }
        List<RoleMenuEntity> menuList = new ArrayList<>(this.getRowKeyList().size());
        for (RowKeyVO rowKeyVO : this.getRowKeyList()) {
            String menuType = rowKeyVO.getRowKey().split("_")[1].trim();
            if (!"-1".equalsIgnoreCase(menuType)) {
                RoleMenuEntity roleMenuEntity = new RoleMenuEntity();
                roleMenuEntity.setMenuId(Long.valueOf(rowKeyVO.getRowKey().split("_")[0]));
                if ("1".equals(menuType)) {
                    roleMenuEntity.setDataPerm(Constant.RoleType.TENANT_ADMIN.getValue());
                }
                menuList.add(roleMenuEntity);
            }
        }
        return menuList;
    }
}
