package com.esv.superhive.cc.module.tenant.form;

import com.esv.superhive.cc.common.form.Add;
import com.esv.superhive.cc.common.form.List;
import com.esv.superhive.cc.common.form.Update;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantAdminForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/13 9:46
 * @version:1.0
 */
@Data
public class TenantAdminForm {

    @NotNull(message="帐号id不能为空", groups = {Update.class})
    @Pattern(regexp = "^[1-9]\\d*$", message = "无效的帐号id", groups = {Update.class})
    private String id;

    /**
     * 用户名
     */
    @Length(max = 50, message = "账号长度不合法", groups = {Add.class})
    @NotEmpty(message="账号不能为空", groups = {Add.class})
    private String account;

    /**
     * 姓名
     */
    @Length(max = 50, message = "姓名长度不合法", groups = {Add.class, Update.class, List.class})
    @NotEmpty(message = "姓名不能为空", groups = {Add.class, Update.class})
    private String realName;

    /**
     * 密码
     */
    @Length(min = 6, max = 32, message = "密码长度不合法", groups = {Add.class, Update.class})
    @NotEmpty(message = "密码不能为空", groups = {Add.class})
    private String password;

    /**
     * 邮箱
     */
    @Email(message = "邮箱不合法", groups = {Add.class, Update.class})
    private String email;

    /**
     * 手机号
     */
    @Length(max = 20, message = "手机号长度不合法", groups = {Add.class, Update.class})
//    @NotEmpty(message = "手机号不能为空", groups = {Add.class, Update.class})
    private String mobile;

    /**
     * 状态  0：禁用   1：正常
     */
//    @NotNull(message="状态不能为空", groups = {Add.class, Update.class})
    @Pattern(regexp = "^[01]{1}$", message = "状态不合法", groups = {Add.class, Update.class})
    private String status;

    /**
     * description 租户id
     * createTime 2020/3/13 11:08
     **/
    @NotNull(message = "租户id不可为空", groups = {Add.class, Update.class})
    private Long tenantId;

}
