package com.esv.superhive.cc.module.tenant.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.esv.superhive.cc.common.constants.Constant;
import com.esv.superhive.cc.common.form.Add;
import com.esv.superhive.cc.common.form.Update;
import com.esv.superhive.cc.form.IdForm;
import com.esv.superhive.cc.module.tenant.dto.TenantAdminDTO;
import com.esv.superhive.cc.module.tenant.entity.TenantEntity;
import com.esv.superhive.cc.module.tenant.form.TenantAdminForm;
import com.esv.superhive.cc.module.tenant.service.TenantAdminService;
import com.esv.superhive.cc.module.tenant.service.TenantService;
import com.esv.superhive.cc.module.user.entity.UserEntity;
import com.esv.superhive.cc.module.user.service.UserRoleService;
import com.esv.superhive.cc.module.user.service.UserService;
import com.esv.common.response.R;
import com.esv.gateway.common.GatewayHeaders;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantAdminController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/12 17:22
 * @version:1.0
 */
@RefreshScope
@RestController
@RequestMapping("tenantAdmin")
public class TenantAdminController {

    private TenantAdminService tenantAdminService;

    private TenantService tenantService;

    private UserService userService;

    private UserRoleService userRoleService;

    @Autowired
    public TenantAdminController(TenantAdminService tenantAdminService, TenantService tenantService,
                                 UserService userService, UserRoleService userRoleService) {
        this.tenantAdminService = tenantAdminService;
        this.tenantService = tenantService;
        this.userService = userService;
        this.userRoleService = userRoleService;
    }

    @GetMapping("list")
    public R list(
            @RequestHeader(GatewayHeaders.DATA_PERM) Integer dataPerm,
            @RequestHeader(GatewayHeaders.TENANT_ID) Long tenantId,
            @RequestParam(value = "current", defaultValue = "1") Integer current,
            @RequestParam(value = "size", defaultValue = "10") Integer size,
            @RequestParam(value = "account", required = false) String account,
            @RequestParam(value = "tenantId", required = false) Long chooseTenantId
    ) {
        IPage<TenantAdminDTO> page = new Page<>(current, size);
        Long queryTenantId = null;
        if (dataPerm != 0) {
            // 没有全部数据权限只能查询当前租户信息
            queryTenantId = tenantId;
        }
        if (chooseTenantId != null) {
            queryTenantId = chooseTenantId;
        }
        page = tenantAdminService.page(page, queryTenantId, account);
        return R.ok(page);
    }

    @PostMapping("add")
    public R add(@RequestBody @Validated(Add.class) TenantAdminForm tenantAdminForm) {
        // 将用户设置为该租户管理员角色
        TenantEntity tenantEntity = tenantService.getById(tenantAdminForm.getTenantId());
        if (tenantEntity == null) {
            return R.error("租户不存在");
        }
        UserEntity userEntity = new UserEntity();
        BeanUtils.copyProperties(tenantAdminForm, userEntity);
        userEntity.setDepartmentId(0L);
        if (StringUtils.isBlank(tenantAdminForm.getStatus())) {
            userEntity.setStatus(0);
        }
        userEntity.setType(Constant.UserType.TENANT_ADMIN.getValue());
        userService.insert(userEntity);
        userRoleService.editUserRole(userEntity.getId(), String.valueOf(tenantEntity.getAdminRoleId()));
        return R.ok();
    }

    @PostMapping("update")
    public R update(@RequestBody @Validated(Update.class) TenantAdminForm tenantAdminForm) {
        // 不可修改用户角色
        UserEntity userEntity = userService.getById(Long.parseLong(tenantAdminForm.getId()));
        BeanUtils.copyProperties(tenantAdminForm, userEntity);
        userEntity.setDepartmentId(0L);
        if (StringUtils.isBlank(tenantAdminForm.getStatus())) {
            userEntity.setStatus(0);
        }
        userService.updateUserInfoById(userEntity);
        return R.ok();
    }

    @PostMapping("delete")
    public R delete(@RequestBody IdForm idForm) {
        userService.delete(idForm.getId());
        return R.ok();
    }

}
