package com.esv.superhive.cc.module.role.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.cc.module.role.dto.RoleDTO;
import com.esv.superhive.cc.module.role.dto.TenantRoleDTO;
import com.esv.superhive.cc.module.role.entity.RoleEntity;
import com.esv.superhive.cc.module.tenant.entity.TenantEntity;

import java.util.List;

/**
 * 角色
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
public interface RoleService extends IService<RoleEntity> {
    /**
     * description 创建租户管理员角色
     * param [tenantEntity]
     * return Long 创建的角色id
     * author chenfm
     * createTime 2020/4/1 17:39
     **/
    Long createTenantAdminRole(TenantEntity tenantEntity);

    /**
     * @description 分页查询角色列表
     * param [page, tenantId, categoryId, roleName]
     * @return void
     * @author chenfm
     * @createTime 2020/3/11 9:45
     **/
    void listRoleDTOPage(IPage<RoleDTO> page, RoleDTO roleDTO);

    /**
     * description 根据租户id查询角色列表
     * param [tenantId]
     * return java.util.List<RoleEntity>
     * author chenfm
     * createTime 2020/3/18 9:39
     **/
    List<RoleEntity> listByTenantId(Long tenantId);

    /**
     * @description 修改角色类别
     * param [categoryId]
     * @return void
     * @author chenfm
     * @createTime 2020/3/11 9:46
     **/
    void updateRoleCategory(long categoryId);

    /**
     * description 是否是超级管理员角色
     * param [role]
     * return java.lang.Boolean
     * author chenfm
     * createTime 2020/4/2 20:29
     **/
    Boolean isSuperAdminRole(Long role);

    /**
     * description 获取管理员角色id
     * param []
     * return java.lang.Long
     * author chenfm
     * createTime 2020/4/8 20:28
     **/
    Long getSuperAdminRoleId();

    /**
     * description 按租户查询所有角色
     * param []
     * return java.util.List<com.esv.cc.module.role.dto.TenantRoleDTO>
     * author chenfm
     * createTime 2020/4/7 19:42
     **/
    List<TenantRoleDTO> allByTenant(Long tenantId, Integer type);

}

