package com.esv.superhive.cc.module.role.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 角色
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-10 15:25:41
 */
@Data
@TableName("cc_role")
public class RoleEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 角色id
	 */
	@TableId
	private Long id;
	/**
	 * 角色名称
	 */
	private String roleName;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 排序
	 */
	private Integer orderNum;
	/**
	 * 租户id
	 */
	private Long tenantId;
	/**
	 * 创建部门id
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 类别id
	 */
	private Long categoryId;
	/**
	 * 角色类型: 0-平台管理角色, 1-租户管理角色, 2-普通角色
	 **/
	private Integer type;
	/**
	 * 创建者ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 更新用户
	 */
	@TableField(fill = FieldFill.UPDATE)
	private String updateUser;
	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.UPDATE)
	private Date updateTime;
	/**
	 * 已删除
	 */
	@TableLogic
	private Boolean deleted;

}
