package com.esv.superhive.cc.module.menu.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.cc.module.menu.dto.MenuDTO;
import com.esv.superhive.cc.module.menu.dto.SystemMenuDTO;
import com.esv.superhive.cc.module.menu.entity.MenuEntity;
import com.esv.superhive.cc.module.menu.form.MenuForm;

import java.util.List;
import java.util.Set;

/**
 * 菜单管理
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-10 15:25:41
 */
public interface MenuService extends IService<MenuEntity> {

    /**
     * description 菜单树列表
     * param []
     * return java.util.List<SystemMenuDTO>
     * author chenfm
     * createTime 2020/3/12 9:25
     **/
    List<SystemMenuDTO> listSystemMenuTree(Long userId);

    /**
     * description 保存或修改菜单
     * param [menuForm]
     * return boolean
     * author chenfm
     * createTime 2020/3/17 14:31
     **/
    boolean saveOrUpdate(MenuForm menuForm);

    /**
     * description 根据前台传入rowKey解析菜单id
     * param [rowKey]
     * return java.lang.Long
     * author chenfm
     * createTime 2020/3/17 14:32
     **/
    Long parseIdByRowKey(String rowKey);

    /**
     * description 递归删除菜单
     * param [menuId]
     * return void
     * author chenfm
     * createTime 2020/3/12 10:25
     **/
    void removeMenuTree(long menuId);

    /**
     * description 查询系统菜单
     * param [systemId, userId, tenantId]
     * return java.util.List<MenuDTO>
     * author chenfm
     * createTime 2020/3/5 17:56
     **/
    List<MenuDTO> listSystemMenu(Long systemId, Long userId, Long tenantId);

    /**
     * description 查询用户或租户可访问接口
     * param [systemId, userId, tenantId]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/16 10:56
     **/
    List<String> listUserPerms(Long systemId, Long userId, Long tenantId);

    /**
     * description 查询所有系统按钮权限
     * param [systemId, userId, tenantId]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/13 17:28
     **/
    List<String> listMenuCode(Long systemId, Long userId, Long tenantId);

    /**
     * description 用户权限
     * param [systemId, userId, tenantId]
     * return java.util.Set<java.lang.String>
     * author chenfm
     * createTime 2020/3/13 16:33
     **/
    Set<String> userPermSet(Long systemId, Long userId, Long tenantId);

    /**
     * description 删除系统所有菜单
     * param [systemId]
     * return void
     * author chenfm
     * createTime 2020/4/8 19:01
     **/
    void deleteBySystemId(Long systemId);

}

