package com.esv.superhive.cc.module.menu.dto;

import lombok.Data;

import java.util.List;

@Data
public class SystemMenuDTO {

    /**
     * 系统id
     */
    private Long id;
    /**
     * 系统名称
     */
    private String name;
    /**
     * 系统图标
     */
    private String icon;
    /**
     * 系统url
     */
    private String url;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;
    /**
     * 类型   -1:应用    0：目录   1：菜单   2：按钮
     */
    private Integer type = -1;
    /**
     * 字段唯一标识
     **/
    private String rowKey;
    /**
     * 菜单列表
     */
    private List<MenuDTO> children;

    public String getRowKey() {
        return id + "_" + type;
    }
}
